<?php

require_once '../config/database.php';
require_once '../config/cors.php';
require_once '../utils/response.php';
require_once '../utils/auth_middleware.php';

setCORS();

$user_id = AuthMiddleware::verifyToken();

if ($_SERVER['REQUEST_METHOD'] !== 'DELETE') {
    Response::error('Méthode non autorisée', 'METHOD_NOT_ALLOWED', 405);
}

$pdo = Database::connect();

try {
    $pdo->beginTransaction();
    
    // Supprimer les données utilisateur
    $stmt = $pdo->prepare('DELETE FROM user_data WHERE user_id = ?');
    $stmt->execute([$user_id]);
    
    // Supprimer les tokens
    $stmt = $pdo->prepare('DELETE FROM oauth_tokens WHERE user_id = ?');
    $stmt->execute([$user_id]);
    
    $pdo->commit();
    
    Response::success(null, 'Données supprimées', 200);
    
} catch (Exception $e) {
    $pdo->rollBack();
    error_log($e->getMessage());
    Response::error('Erreur suppression', 'DELETE_ERROR', 500);
}
