<?php

require_once '../config/database.php';
require_once '../config/cors.php';
require_once '../utils/response.php';

setCORS();

$data = json_decode(file_get_contents('php://input'), true);

// Validation
if (empty($data['email']) || empty($data['password']) || empty($data['username'])) {
    Response::error('Données manquantes', 'MISSING_DATA', 400);
}

$email = filter_var($data['email'], FILTER_VALIDATE_EMAIL);
if (!$email) {
    Response::error('Email invalide', 'INVALID_EMAIL', 400);
}

if (strlen($data['password']) < 8) {
    Response::error('Mot de passe trop court (min 8 caractères)', 'WEAK_PASSWORD', 400);
}

$pdo = Database::connect();

try {
    // Vérifier si l'email existe
    $stmt = $pdo->prepare('SELECT id FROM users WHERE email = ?');
    $stmt->execute([$email]);
    
    if ($stmt->fetch()) {
        Response::error('Email déjà utilisé', 'EMAIL_EXISTS', 409);
    }
    
    // Créer l'utilisateur
    $password_hash = password_hash($data['password'], PASSWORD_BCRYPT);
    $stmt = $pdo->prepare('
        INSERT INTO users (email, username, password_hash) 
        VALUES (?, ?, ?)
    ');
    $stmt->execute([$email, htmlspecialchars($data['username']), $password_hash]);
    
    Response::success(['user_id' => $pdo->lastInsertId()], 'Utilisateur créé', 201);
    
} catch (Exception $e) {
    error_log($e->getMessage());
    Response::error('Erreur création utilisateur', 'DB_ERROR', 500);
}
