<?php

require_once '../config/database.php';
require_once '../config/cors.php';
require_once '../utils/response.php';

setCORS();

$data = json_decode(file_get_contents('php://input'), true);

if (empty($data['refresh_token'])) {
    Response::error('Refresh token manquant', 'MISSING_TOKEN', 400);
}

$pdo = Database::connect();

try {
    $stmt = $pdo->prepare('
        SELECT user_id FROM oauth_tokens 
        WHERE refresh_token = ? AND expires_at > NOW()
    ');
    $stmt->execute([$data['refresh_token']]);
    $token = $stmt->fetch();
    
    if (!$token) {
        Response::error('Refresh token invalide', 'INVALID_REFRESH_TOKEN', 401);
    }
    
    // Générer nouveau access token
    $new_access_token = bin2hex(random_bytes(32));
    $expires_at = date('Y-m-d H:i:s', strtotime('+7 days'));
    
    $stmt = $pdo->prepare('
        UPDATE oauth_tokens 
        SET access_token = ?, expires_at = ? 
        WHERE refresh_token = ?
    ');
    $stmt->execute([$new_access_token, $expires_at, $data['refresh_token']]);
    
    Response::success([
        'access_token' => $new_access_token,
        'expires_in' => 604800
    ], 'Token rafraîchi', 200);
    
} catch (Exception $e) {
    error_log($e->getMessage());
    Response::error('Erreur rafraîchissement', 'REFRESH_ERROR', 500);
}
