# Workzen API REST - PHP

API REST complète pour la synchronisation de données Workzen entre Flutter (Floor/SQLite) et MySQL.

## Structure des Dossiers

```
api-php/
├── config/
│   ├── database.php      # Configuration MySQL
│   └── cors.php           # Configuration CORS
├── utils/
│   ├── response.php       # Helper réponses JSON
│   └── auth_middleware.php # Middleware OAuth
├── auth/
│   ├── register.php       # Inscription
│   ├── login.php          # Connexion OAuth
│   ├── refresh.php        # Rafraîchir token
│   └── logout.php         # Déconnexion
├── sync/
│   ├── auto.php           # Sync automatique (PRINCIPAL)
│   ├── status.php         # Statut de sync
│   └── data.php           # Suppression données
└── schema.sql             # Schéma MySQL
```

## Installation

### 1. Base de Données

```bash
mysql -u root -p < schema.sql
```

### 2. Configuration

Modifier `config/database.php`:
```php
'host' => 'localhost',
'db_name' => 'workzen_db',
'user' => 'root',
'password' => 'votre_mot_de_passe',
```

Modifier `config/cors.php`:
```php
$allowed_origins = ['http://localhost', 'https://votre-domaine.com'];
```

### 3. Serveur Web

- Apache: Placer dans `/var/www/html/api-php/`
- Nginx: Configurer le root vers le dossier
- PHP 8.0+ requis

## Endpoints

### Authentification

**POST** `/auth/register`
```json
{
  "email": "user@example.com",
  "username": "John Doe",
  "password": "securePassword123"
}
```

**POST** `/auth/login`
```json
{
  "email": "user@example.com",
  "password": "securePassword123"
}
```
Retourne: `access_token`, `refresh_token`, `expires_in`

**POST** `/auth/refresh`
```json
{
  "refresh_token": "..."
}
```

**POST** `/auth/logout`
Headers: `Authorization: Bearer {token}`

### Synchronisation

**POST** `/sync/auto` (Endpoint Principal)
```json
{
  "email": "user@example.com",
  "data": {
    "version": "1.0",
    "exportDate": "2024-01-01T12:00:00Z",
    "projects": [...],
    "sections": [...],
    "tasks": [...]
  },
  "lastSync": "2024-01-01T11:00:00Z"
}
```
Headers: `Authorization: Bearer {token}`

**GET** `/sync/status?email=user@example.com`
Headers: `Authorization: Bearer {token}`

**DELETE** `/sync/data?email=user@example.com`
Headers: `Authorization: Bearer {token}`

## Logique de Synchronisation

1. **Première sync**: Stocke les données locales
2. **Sync suivantes**: Compare timestamps
   - Local > Remote → Met à jour serveur
   - Remote > Local → Retourne données serveur
   - Égaux → Pas de changement
3. **Version**: Incrémentée à chaque mise à jour

## Sécurité

- ✅ Passwords hashés (bcrypt)
- ✅ Tokens OAuth sécurisés
- ✅ Requêtes préparées PDO
- ✅ Validation des entrées
- ✅ CORS configuré
- ✅ Expiration tokens (7 jours)

## Test avec cURL

```bash
# Register
curl -X POST http://localhost/api-php/auth/register \
  -H "Content-Type: application/json" \
  -d '{"email":"test@test.com","username":"Test","password":"password123"}'

# Login
curl -X POST http://localhost/api-php/auth/login \
  -H "Content-Type: application/json" \
  -d '{"email":"test@test.com","password":"password123"}'

# Sync
curl -X POST http://localhost/api-php/sync/auto \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -H "Content-Type: application/json" \
  -d '{"email":"test@test.com","data":{...},"lastSync":"2024-01-01T12:00:00Z"}'
```

## Logs

Les erreurs sont enregistrées via `error_log()`. Vérifier les logs PHP du serveur.

## Production

- Activer HTTPS
- Configurer rate limiting
- Sauvegardes régulières MySQL
- Monitorer les performances
